/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.xport;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.impl.TaskletData;
import com.ibm.hwmca.fw.tasklet.impl.TaskletInitialRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ExitControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ExitControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.NullControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.TerminateControlRequest;
import com.ibm.hwmca.fw.tasklet.xport.AbnormalTaskletTerminationException;
import com.ibm.hwmca.fw.tasklet.xport.ConversationComponent;
import com.ibm.hwmca.fw.tasklet.xport.TaskletCommunicationClient;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;
import java.util.Map;

public class TaskletClient {
    private static final String UNIFIED_TRANSPORT = "com.ibm.hwmca.fw.tasklet.xport.monad.MonadClient";
    private static final String DEFAULT_TRANSPORT = "com.ibm.hwmca.fw.tasklet.xport.stream.StreamClient";
    private static final String TASKLET_MANAGER_CLASS_NAME = "com.ibm.hwmca.fw.tasklet.xport.TaskletManager";
    private static final String TRACE_MASKT = "XTSKCXCT";
    private static final String TRACE_MASKF = "XTSKCXCF";
    private static final String TRACE_MASKD = "XTSKCXCD";
    protected TaskletCommunicationClient taskletCommunicationClient = null;
    protected Map context = null;
    protected int traceId = -1;
    protected TaskletData taskletData = null;
    protected boolean terminate = false;
    protected ControlProcessor controlProcessor = null;
    protected int taskletId = -1;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$system$ClientUserContext;

    public TaskletClient(TaskletData taskletData, ClientUserContext clientUserContext) throws TaskletException {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.ctor> taskletData=").append(taskletData).append(", clientUserContext=").append(clientUserContext).toString());
        TaskletCommunicationClient newclient = null;
        String transportClassName = DEFAULT_TRANSPORT;
        if (CommonSystem.getCommonSystem().isLocationUnified()) {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] notes unified location, using unified transport.").toString());
            transportClassName = UNIFIED_TRANSPORT;
        }
        try {
            Class<?> theClass = Class.forName(transportClassName);
            if (clientUserContext != null) {
                Class[] constArgs = new Class[]{class$com$ibm$hwmca$fw$system$ClientUserContext == null ? (class$com$ibm$hwmca$fw$system$ClientUserContext = TaskletClient.class$("com.ibm.hwmca.fw.system.ClientUserContext")) : class$com$ibm$hwmca$fw$system$ClientUserContext};
                Constructor<?> constructor = theClass.getConstructor(constArgs);
                if (constructor != null) {
                    Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Using transport constructor that accepts clientUserContext").toString());
                    newclient = (TaskletCommunicationClient)constructor.newInstance(clientUserContext);
                } else {
                    Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Couldn't find a constructor that accepted clientUserContext, using no-arg constructor").toString());
                    newclient = (TaskletCommunicationClient)theClass.newInstance();
                }
            } else {
                Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Using transport no-arg constructor").toString());
                newclient = (TaskletCommunicationClient)theClass.newInstance();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Failure to create default communication client ").append(taskletData).toString());
            throw new TaskletException(e);
        }
        this.taskletCommunicationClient = newclient;
        this.taskletData = taskletData;
        this.taskletCommunicationClient.setTraceId(this.traceId);
    }

    public TaskletClient(TaskletData taskletData) throws TaskletException {
        this(taskletData, null);
    }

    public TaskletClient(TaskletCommunicationClient taskletCommunicationClient, TaskletData taskletData) throws TaskletException {
        this.taskletCommunicationClient = taskletCommunicationClient;
        this.taskletData = taskletData;
        taskletCommunicationClient.setTraceId(this.traceId);
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.ctor> taskletData=").append(taskletData).toString());
    }

    protected void finalize() {
        this.terminate();
    }

    public boolean isAuthenticated() {
        return this.taskletCommunicationClient.isAuthenticated();
    }

    public final TaskletData getTaskletData() {
        return this.taskletData;
    }

    public final int getTaskletId() {
        return this.taskletId;
    }

    public TaskletResponse init(Map initialData) throws TaskletException {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] init(").append(initialData).append(")").toString());
        TaskletInitialRequest initialRequest = new TaskletInitialRequest(this.taskletData, this.getManagerName());
        initialRequest.setDataMap(initialData);
        if (this.controlProcessor == null) {
            this.controlProcessor = new ControlProcessor();
            this.controlProcessor.start();
        }
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.init> (initial request) -f-l-o-w-s->>> ").append(initialRequest).toString());
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Request detail follows:").toString());
        initialRequest.debugToTrace();
        TaskletResponse initialResponse = this.taskletCommunicationClient.init(initialRequest);
        this.traceId = this.taskletId = initialResponse.getTaskletId();
        this.taskletCommunicationClient.setTraceId(this.traceId);
        if (initialResponse.isContextSet()) {
            this.context = initialResponse.getContext();
        }
        this.taskletData.setTaskletId(initialResponse.getTaskletId());
        this.controlProcessor.setName("Tasklet:" + this.taskletData.getTaskletId() + ":control (" + this.taskletData.getServerTaskletClass() + ")");
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.init> (initial response) <<<-o-b-t-a-i-n-s- ").append(initialResponse).toString());
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Response detail follows:").toString());
        initialResponse.debugToTrace();
        return initialResponse;
    }

    protected String getManagerName() {
        return TASKLET_MANAGER_CLASS_NAME;
    }

    protected final String getDefaultTransport() {
        return DEFAULT_TRANSPORT;
    }

    protected ControlResponse handleControlRequest(ControlRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.handleControlRequest> request=").append(request).toString());
        ControlResponse response = null;
        if (request == null) {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletPanelClient:").append(this.traceId).append(":CP] ignorning null response, maybe due to redirect processing'.").toString());
        } else if (request instanceof ExitControlRequest) {
            response = this.processControlRequest((ExitControlRequest)request);
        } else if (request instanceof TerminateControlRequest) {
            this.terminate();
        } else {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletPanelClient:").append(this.traceId).append(":CP] UNKNOWN request received! '").append(request).append("'.").toString());
            if (!this.terminate) {
                this.abnormalTermination(new AbnormalTaskletTerminationException("Unknown control request was received: " + request));
            }
        }
        return response;
    }

    public ControlResponse processControlRequest(ExitControlRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append(":CP] <xtsk:tclient.processControlRequest> (Exit) entry").toString());
        Object answer = null;
        try {
            answer = request.runExit();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append(":CP] processControlRequest() (Exit) Exception driving exit ").append(e).toString());
            throw new TaskletException(e);
        }
        return new ExitControlResponse(answer);
    }

    protected void abnormalTermination(AbnormalTaskletTerminationException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void terminate() {
        block10: {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] terminate()").toString());
            if (!this.terminate) {
                this.terminate = true;
                Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] attempting post of TCR to peer.").toString());
                this.postControlRequest(new TerminateControlRequest());
                Object var3_1 = null;
                try {
                    this.taskletCommunicationClient.terminate();
                }
                catch (Exception te) {
                    // empty catch block
                }
                this.taskletCommunicationClient = null;
                {
                    break block10;
                    catch (Exception exception) {
                        Object var3_2 = null;
                        try {
                            this.taskletCommunicationClient.terminate();
                        }
                        catch (Exception te) {
                            // empty catch block
                        }
                        this.taskletCommunicationClient = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        this.taskletCommunicationClient.terminate();
                    }
                    catch (Exception te) {
                        // empty catch block
                    }
                    this.taskletCommunicationClient = null;
                    throw throwable;
                }
            }
        }
    }

    protected void postControlRequest(ControlRequest request) throws TaskletException {
        this.taskletCommunicationClient.postControlRequest(request);
    }

    protected ControlRequest getControlRequest(ControlResponse response) throws TaskletException {
        ControlRequest request = this.taskletCommunicationClient.getControlRequest(response);
        if (request instanceof TerminateControlRequest) {
            this.terminate();
        }
        return request;
    }

    protected TaskletResponse request(TaskletRequest request) throws TaskletException {
        TaskletResponse response;
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] request()").toString());
        if (request != null) {
            request.setContext(this.context);
            this.context = null;
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.flowsRequest> request = ").append(request).toString());
            response = this.taskletCommunicationClient.request(request);
            this.taskletId = response.getTaskletId();
            if (response.isContextSet()) {
                this.context = response.getContext();
            }
        } else {
            Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] Protocol: A request must be non-null.").toString());
            throw new TaskletException("Protocol: A request must be non-null.");
        }
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:").append(this.traceId).append("] <xtsk:tclient.obtainsResponse> response = ").append(response).toString());
        return response;
    }

    public Connection connect(String name, ConversationComponent initData) throws TaskletException {
        return this.taskletCommunicationClient.connect(name, initData);
    }

    public final int getTraceId() {
        return this.traceId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ControlProcessor
    extends Thread {
        public void run() {
            Trace.trace(TaskletClient.TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:CP:").append(TaskletClient.this.traceId).append("] <xtsk:tclient.cp-thread.begins>").toString());
            this.setName("Embryonic (not init()'ed yet) Tasklet Control Thread");
            ControlResponse response = null;
            while (!TaskletClient.this.terminate) {
                try {
                    Trace.trace(TaskletClient.TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:CP:").append(TaskletClient.this.traceId).append("] <xtsk:tclient.cp-thread.reads> Blocks waiting for any inbound cntrl requests (sends response=").append(response).append(")").toString());
                    if (response == null) {
                        response = new NullControlResponse();
                    }
                    ControlRequest request = TaskletClient.this.getControlRequest(response);
                    Trace.trace(TaskletClient.TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:CP:").append(TaskletClient.this.traceId).append("] <xtsk:tclient.cp-thread.receives> obtains cntrl request '").append(request).append("'").toString());
                    response = TaskletClient.this.handleControlRequest(request);
                    Trace.trace(TaskletClient.TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:CP:").append(TaskletClient.this.traceId).append("] back from control request handler.").toString());
                }
                catch (Exception e) {
                    if (!TaskletClient.this.terminate) {
                        Trace.trace(TaskletClient.TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:CP:").append(TaskletClient.this.traceId).append("] Exception! posting task with AbnormalTerminationException").toString());
                        TaskletClient.this.abnormalTermination(new AbnormalTaskletTerminationException(e));
                    }
                    TaskletClient.this.terminate();
                }
            }
            Trace.trace(TaskletClient.TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("[TaskletClient:CP:").append(TaskletClient.this.traceId).append("] <xtsk:tclient.cp-thread.ends>").toString());
        }
    }
}

